//---------------------------------------------------------------------------

#ifndef LinkLabelH
#define LinkLabelH
//---------------------------------------------------------------------------
#include <SysUtils.hpp>
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
//---------------------------------------------------------------------------
class PACKAGE TLinkLabel : public TCustomLabel
{
private:
	void __fastcall DodajPodkreslenie(TObject* Sender);
	void __fastcall UsunPodkreslenie(TObject* Sender);
protected:
	AnsiString FAdres;
	virtual bool SprawdzAdres(AnsiString AAdres) =0;
	virtual void __fastcall SetAdres(AnsiString AAdres) =0;
public:
	__fastcall TLinkLabel(TComponent* Owner);
	void __fastcall Polacz(TObject* Sender);
__published:
	__property AnsiString Adres={read=FAdres,write=SetAdres};
	//publikowanie wlasnosci
	__property Caption;
	__property Font;
	__property AutoSize;
	__property Color;
	__property PopupMenu;
	//publikowanie zdarzen
	__property OnDragOver;
	__property OnDragDrop;
	__property OnEndDrag;
};

class PACKAGE TLink : public TLinkLabel
{
protected:
	virtual bool SprawdzAdres(AnsiString AAdres);
	virtual void __fastcall SetAdres(AnsiString AAdres);
public:
	__fastcall TLink(TComponent* Owner);
};

class PACKAGE TMail : public TLinkLabel
{
protected:
	virtual bool SprawdzAdres(AnsiString AAdres);
	virtual void __fastcall SetAdres(AnsiString AAdres);
public:
	__fastcall TMail(TComponent* Owner);
};

//---------------------------------------------------------------------------
#endif
